<?php declare(strict_types=1);
/**
 * @author Ryan Spaeth <rspaeth@spaethtech.com>
 * @copyright 2025 - Spaeth Technologies, Archous Networks
 */

use DI\Bridge\Slim\Bridge;
use DI\ContainerBuilder;
use Slim\Routing\RouteCollectorProxy;
use Slim\Views\Twig;
use Slim\Views\TwigMiddleware;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;
use SpaethTech\UCRM\SDK\Middleware\QueryRoutingMiddleware;
use SpaethTech\UCRM\SDK\Controllers\ServicesCheckController;
use SpaethTech\UCRM\SDK\Controllers\ServicesWebhookController;
use SpaethTech\UCRM\SDK\Controllers\ApiErrorController;
use SpaethTech\UCRM\SDK\Controllers\FallbackController;

require_once __DIR__ . "/bootstrap.php";

$builder = new ContainerBuilder();
$builder->addDefinitions(__DIR__ . "/container.php");
$container = $builder->build();

$app = Bridge::create($container);

$app->add(TwigMiddleware::createFromContainer($app, Twig::class));

$app->addBodyParsingMiddleware();
$app->addRoutingMiddleware();

$errorMiddleware = $app->addErrorMiddleware(true, true, true);

$app->add(new QueryRoutingMiddleware());

$app->group("/api", function (RouteCollectorProxy $group) use ($app) {

  $group->get(
    "/ping",
    function (Request $request, Response $response) {
      $response->getBody()->write(json_encode(["ping" => "pong"]));
      return $response->withHeader("Content-Type", "application/json");
    }
  );

  $group->post("/services/check", [ServicesCheckController::class, 'check']);

  // Single service webhook endpoint - handles all webhook types
  $group->post("/services/webhook", [ServicesWebhookController::class, 'webhook']);

  $group->map(
    ["GET", "POST", "PUT", "DELETE", "PATCH", "HEAD", "OPTIONS"],
    "/{path:.*}",
    [ApiErrorController::class, 'notFound']
  );
});


// Define app routes
$app->get("/{path:.*}", [FallbackController::class, 'handlePublicRoute']);

// Run app
$app->run();
