<?php declare(strict_types=1);
/**
 * @author Ryan Spaeth <rspaeth@spaethtech.com>
 * @copyright 2025 - Spaeth Technologies, Archous Networks
 */

namespace SpaethTech\UCRM\SDK\Controllers;

use GuzzleHttp\Client;
use Slim\Views\Twig;
use SpaethTech\UCRM\SDK\Plugin;

abstract class BaseController
{
    public function __construct(
        protected readonly Plugin $plugin,
        protected readonly Client $client,
        protected readonly Twig $twig
    ) {
        $this->validateDependencies();
    }

    protected function validateDependencies(): void
    {
        if (!$this->plugin) {
            throw new \InvalidArgumentException("Plugin dependency is required");
        }
        
        if (!$this->client) {
            throw new \InvalidArgumentException("Client dependency is required");
        }
        
        if (!$this->twig) {
            throw new \InvalidArgumentException("Twig dependency is required");
        }
    }
}