<?php declare(strict_types=1);
/**
 * @author Ryan Spaeth <rspaeth@spaethtech.com>
 * @copyright 2025 - Spaeth Technologies, Archous Networks
 */

namespace SpaethTech\UCRM\SDK\Configs\Abstracts;

use SpaethTech\UCRM\SDK\Configs\Interfaces\ReadOnlyConfigInterface;

abstract class ReadOnlyConfig implements ReadOnlyConfigInterface
{
    protected array $data;

    public function __construct(protected string $file)
    {
    }

    public function get(string $key, mixed $default = null): mixed
    {
        $keys = explode(".", $key);
        $value = $this->data;

        foreach ($keys as $k) {
            if (!is_array($value) || !array_key_exists($k, $value)) {
                return $default;
            }
            $value = $value[$k];
        }

        return $value;

        //return $this->data[$key] ?? $default;
    }

    public function __toString(): string
    {
        return json_encode($this->data);
    }

    public function toString(int $flags): string
    {
        return json_encode($this->data, $flags);
    }

    public function toArray(): array
    {
        return $this->data;
    }

}

