<?php declare(strict_types=1);
/**
 * @author Ryan Spaeth <rspaeth@spaethtech.com>
 * @copyright 2025 - Spaeth Technologies, Archous Networks
 */

namespace SpaethTech\UCRM\SDK\Configs;

use SpaethTech\UCRM\SDK\Plugin;

class PluginConfig extends Abstracts\Config
{
    private const JSON_OPTS = JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES;

    public function __construct(protected Plugin $plugin, protected string $path = "data/config.json")
    {
        parent::__construct($plugin->getPath($path));
        $this->load();
    }

    public function load(): self
    {
        $this->data = json_decode(file_get_contents($this->file), true);
        return $this;
    }

    public function save(): self
    {
        $contents = json_encode($this->data, self::JSON_OPTS);
        file_put_contents($this->file, $contents);
        return $this;
    }
}
