<?php declare(strict_types=1);
/**
 * @author Ryan Spaeth <rspaeth@spaethtech.com>
 * @copyright 2025 - Spaeth Technologies, Archous Networks
 */

namespace SpaethTech\UCRM\SDK\Configs;

use SpaethTech\UCRM\SDK\Plugin;

class PluginUcrm extends Abstracts\ReadOnlyConfig
{
    public function __construct(protected Plugin $plugin)
    {
        parent::__construct($plugin->getPath("ucrm.json"));
        $this->load();
    }

    public function load(): self
    {
        $this->data = json_decode(file_get_contents($this->file), true);
        return $this;
    }

    public function getUcrmPublicUrl(): string
    {
        return $this->data["ucrmPublicUrl"];
    }

    public function getUcrmLocalUrl(): string
    {
        return $this->data["ucrmLocalUrl"];
    }

    public function getUnmsLocalUrl(): string
    {
        return $this->data["unmsLocalUrl"];
    }

    public function getPluginPublicUrl(): string
    {
        return $this->data["pluginPublicUrl"];
    }

    public function getPluginAppKey(bool $fallback = true): string
    {
        return $this->data["pluginAppKey"] ?? $fallback
            ? $this->plugin->getServer()->getUcrmToken()
            : null;
    }

    public function getPluginId(): int
    {
        return $this->data["pluginId"];
    }

}
