// Self-loading cache-busted version
(function () {
  // Find the current script tag
  const currentScript =
    document.currentScript ||
    Array.from(document.getElementsByTagName("script")).find((s) =>
      s.src.includes("admin-zone.js")
    );

  // Extract the public path from current script's src
  const publicPath = currentScript
    ? currentScript.src.replace(/\/admin-zone\.js.*$/, "")
    : "/crm/_plugins/provisioner-v2/public";

  // Create new script element
  const script = document.createElement("script");
  script.src = `${publicPath}/admin-zone.uncached.js?v=${Date.now()}`;
  script.type = "text/javascript";

  // Insert right after the current script
  if (currentScript && currentScript.parentNode) {
    currentScript.parentNode.insertBefore(script, currentScript.nextSibling);
  } else {
    // Fallback to head if we can"t find the current script
    document.head.appendChild(script);
  }
})();
