<?php declare(strict_types=1);
/**
 * @author Ryan Spaeth <rspaeth@spaethtech.com>
 * @copyright 2025 - Spaeth Technologies, Archous Networks
 */

namespace SpaethTech\UCRM\SDK\Enums;

enum ClientServiceWidgets: string
{
    case INFORMATION = <<<TWIG
                <div id="service_information">
                    {% include 'client/services/components/view/information.html.twig' %}
                </div>
TWIG;

    case PREPAID_PERIODS = <<<TWIG
                {% if service.prepaid %}
                    <div id="service_prepaid_periods">
                        {% include 'client/services/components/view/prepaid_periods.html.twig' %}
                    </div>
                {% endif %}
TWIG;

    case INVOICE_INFORMATION = <<<TWIG
                {% if not service.prepaid %}
                    <div id="service_invoice_information">
                        {% include 'client/services/components/view/invoice_information.html.twig' %}
                    </div>
                {% endif %}
TWIG;

    case QUOTES = <<<TWIG
                <div id="service_quotes">
                    {% include 'client/services/components/view/quotes.html.twig' %}
                </div>
TWIG;

    case PLUGIN_WIDGETS = <<<TWIG
                {% include 'client/services/components/view/plugin_widgets.html.twig' %}
TWIG;

    case CHARTS = <<<TWIG
                <div id="service_charts">
                    {% include 'client/services/components/view/charts.html.twig' %}
                </div>
TWIG;

    case MAP = <<<TWIG
                <div id="service-map-container">
                    {% include 'client/services/components/view/map.html.twig' %}
                </div>
TWIG;

    case NETWORK = <<<TWIG
                {% if service.tariff.servicePlanType.isInternetType %}
                    <div id="service-network">
                        {% include 'client/services/components/view/network.html.twig' %}
                    </div>
                {% endif %}
TWIG;

    case CONTRACT = <<<TWIG
                {% if not service.prepaid or service.contractId is not null %}
                    {% include 'client/services/components/view/contract.html.twig' %}
                {% endif %}
TWIG;

    case ATTRIBUTES = <<<TWIG
                {% include 'client/services/components/view/attributes.html.twig' %}
TWIG;

    // FUTURE: Watch for templates changes in the future...

}
