<?php declare(strict_types=1);
/**
 * @author Ryan Spaeth <rspaeth@spaethtech.com>
 * @copyright 2025 - Spaeth Technologies, Archous Networks
 */

namespace SpaethTech\UCRM\SDK\Configs;

use SpaethTech\UCRM\SDK\Plugin;

class PluginAuth extends Abstracts\ReadOnlyConfig
{
    public function __construct(protected Plugin $plugin)
    {
        parent::__construct($plugin->getPath("data", "auth.json"));
        $this->load();
    }

    public function load(): self
    {
        $this->data = json_decode(file_get_contents($this->file), true);
        return $this;
    }

    public function getProvApiUrl(): string
    {
        return $this->data["prov_api_url"];
    }

    public function getCryptoPassword(): string
    {
        return $this->data["crypto_password"];
    }

    public function getAuthServiceId(): ?string
    {
        return $this->data["auth_service_id"];
    }

    public function getXAuthToken(): string
    {
        return $this->data["x_auth_token"];
    }
}
